CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
    MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.tables WHERE UPPER(TABLE_NAME) = 'RC_RESP_TEC_CSRT') THEN 
        CREATE TABLE RC_RESP_TEC_CSRT (
            UF_CSRT varchar(2) NOT NULL,
			DESC_CSRT varchar(100) NOT NULL,
			CD_CSRT int NOT NULL,
			ATIVO_CSRT INT NOT NULL,
			CONSTRAINT RC_RESP_TEC_CSRT_PKEY PRIMARY KEY (UF_CSRT,CD_CSRT,DESC_CSRT)
        )
		WITH (OIDS=FALSE);
    ELSE    
        MSGFINAL := 'A TABELA JÁ EXISTE';
    END IF;

    RAISE NOTICE 'TABELA RC_RESP_TEC_CSRT %', MSGFINAL::VARCHAR;

END; 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();